<?php
namespace Elementor;

defined( 'ABSPATH' ) || die();

class Apeix_Icons_Manager {

    public static function init() {
        add_filter( 'elementor/icons_manager/additional_tabs', [ __CLASS__, 'add_apeix_icons_tab' ] );
    }

    public static function add_apeix_icons_tab( $tabs ) {
        $tabs['apeix-icons'] = [
            'name' => 'apeix-icons',
            'label' => __( 'Apeix Icons', 'apeix-elementor-addons' ),
            'url' => APEIX_PLUGIN_URL . 'elementor/assets/css/flaticon.css',
            'enqueue' => [ APEIX_PLUGIN_URL . 'elementor/assets/css/flaticon.css' ],
            'prefix' => 'flaticon-',
            'displayPrefix' => 'fi',
            'labelIcon' => 'flaticon-plane',
            'ver' => '1.0.0',
            'fetchJson' => APEIX_PLUGIN_URL . 'elementor/assets/js/apeix-icons.js?v=1.0.0',
            'native' => false,
        ];
        return $tabs;
    }

    /**
     * Get a list of apeix icons
     *
     * @return array
     */
    public static function get_apeix_icons() {
        return [
            'flaticon-clock' => 'clock',
            'flaticon-alarm-clock'  => 'alarm-clock',
            'flaticon-hand' => 'hand',
            'flaticon-piggy-bank' => 'piggy-bank',
            'flaticon-money-bag' => 'money-bag',
            'flaticon-worker' => 'worker',
            'flaticon-employee' => 'employee',
            'flaticon-business-and-finance' => 'business-and-finance',
            'flaticon-car' => 'car',
            'flaticon-writer' => 'writer',
            'flaticon-play-button' => 'play-button',
            'flaticon-turbo' => 'turbo',
            'flaticon-tyre' => 'tyre',
            'flaticon-car-1' => 'car-1',
            'flaticon-car-2' => 'car-2',
            'flaticon-car-repair' => 'car-repair',
            'flaticon-battery' => 'battery',
            'flaticon-electricity' => 'electricity',
            'flaticon-message' => 'message',
            'flaticon-call' => 'call',
            'flaticon-placeholder' => 'placeholder',
        ];
    }
}

Apeix_Icons_Manager::init();